//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.data.Core 1.0
import wesual.Controls 1.0

Item {
    id : filterBarItem

    property RangeFilter    filter
    property alias          label  : priceFilter.text
    property alias          checked : priceFilter.checked
    property int            inputWidth : 50
    property int            inputMethodHints : - 1
    property alias          fromFieldText : fromField.text
    property alias          toFieldText   : toField.text

    property DoubleValidator validator : null

    function toDouble(input) {
        return Number.fromLocaleString(input);
    }

    function checkFilter() {
        if (filter.toValue < filter.fromValue) {
            var tmp = filter.toValue;
            filter.toValue = filter.fromValue;
            filter.fromValue = tmp;

            toField.text   = filter.toValue;
            fromField.text = filter.fromValue;
        }
    }

    height : 30
    width : row.width + row.anchors.leftMargin

    Component.onCompleted : {
        // set filter to min and max value
        filter.fromValue = Number.MIN_VALUE;
        filter.toValue   = Number.MAX_VALUE;
    }

    Row {
        id : row
        height : 30
        anchors.left : parent.left
        anchors.leftMargin : 8
        anchors.verticalCenter : parent.verticalCenter
        spacing : 4

        CheckBox {
            id : priceFilter
            anchors.verticalCenter : parent.verticalCenter
            onCheckedChanged : {
                if (checked)
                    fromField.forceActiveFocus();

                filter.enabled = checked;
            }
        }

        TextField {
            id : fromField

            Timer {
                id : fromTimer
                interval : 500
                running : false
                repeat : false

                // when input delay elapsed start filtering
                onTriggered : {
                    if(fromField.activeFocus) {
                        if (fromField.text === "") {
                            filter.fromValue = Number.MIN_VALUE;
                        } else {
                            filter.fromValue = toDouble(fromField.text);
                            checkFilter();
                        }
                    }
                }
            }
            onTextChanged : {
                if (fromField.activeFocus)
                    fromTimer.restart();
            }
            onEditFinished : {
                filter.fromValue = toDouble(fromField.text);
                checkFilter();
            }

            anchors.verticalCenter : parent.verticalCenter
            width : inputWidth
            height : 26
            placeholderText : qsTrId("ca8b107b568dba1e")
            inputMethodHints : filterBarItem.inputMethodHints
            validator : filterBarItem.validator
            enabled : priceFilter.checked
        }

        Text {
            anchors.verticalCenter : parent.verticalCenter
            text : "–"
            font {
                family : UI.fontFamily(UI.PrimaryFont)
                weight : UI.fontWeight(UI.PrimaryFont)
                pixelSize : 13
            }
            color : UI.color(UI.PrimaryTextColor)
        }

        TextField {
            id : toField

            Timer {
                id : toTimer
                interval : 500
                running : false
                repeat : false

                // when input delay elapsed start filtering
                onTriggered : {
                    if(toField.activeFocus) {
                        if (toField.text === "") {
                            filter.toValue = Number.MAX_VALUE;
                        } else {
                            filter.toValue = toDouble(toField.text);
                            checkFilter();
                        }
                    }
                }
            }
            onTextChanged : {
                if (toField.activeFocus)
                    toTimer.restart();
            }
            onEditFinished : {
                filter.toValue = toDouble(toField.text);
                checkFilter();
            }
            anchors.verticalCenter : parent.verticalCenter
            width : inputWidth
            height : 26
            placeholderText : qsTrId("922dcce3ae33cf1f")
            inputMethodHints : filterBarItem.inputMethodHints
            validator : filterBarItem.validator
            enabled : priceFilter.checked
        }
    }
}
